<?php
/*--------------------------------------------------------------------------------------------------
    add_clear_cache_admin_access.php 2023-09-18
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2023 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

/**
 * Checks if any of the "$clearCacheAdminAccess" entries are already in the database.
 *
 * - If no result has been found, it means we need to add all the entries to the DB.
 * - Otherwise, we add only the ones that are not yet in the DB.
 *
 * NOTE: The `admin_access_group_id` = 28 is fixed, because the ID belongs to the Cache admin access =>
 * `admin_access_group_descriptions`.
 *
 * @var DatabaseModel $this
 * @var int           $t_success
 */

declare(strict_types=1);

$toBeAdded             = [];
$clearCacheAdminAccess = [
    'ROUTE'      => ['/admin/clear-cache'],
    'CONTROLLER' => [
        'AdminCacheAjax',
        'AdminCacheAjax/default',
        'AdminCacheAjax/page',
        'AdminCacheAjax/module',
        'AdminCacheAjax/category',
        'AdminCacheAjax/filter',
        'AdminCacheAjax/text',
        'AdminCacheAjax/email',
    ],
];

$types    = array_keys($clearCacheAdminAccess);
$inClause = '';

// Builds the `IN` clause for all the admin accesses
foreach ($types as $type) {
    $identifiers = "'" . implode("','", $clearCacheAdminAccess[$type]) . "'";
    $inClause    .= " (`type` = '{$type}' AND `identifier` IN ({$identifiers})) OR";
}
$inClause = rtrim($inClause, ' OR');

// Searches for any existing access
$sql    = "SELECT `identifier`, `type` FROM `admin_access_group_items` WHERE `admin_access_group_id` = 28 AND ({$inClause})";
$result = $this->query($sql, true);

// If no result has been found, insert all the entries from the `$clearCacheAdminAccess` array
if ($result->num_rows === 0) {
    $toBeAdded = $clearCacheAdminAccess;
} else {
    $rows = $result->fetch_all(MYSQLI_ASSOC);
    
    // Parses the database result to the "$toBeAdded" array
    foreach ($rows as ['type' => $type, 'identifier' => $identifier]) {
        $toBeAdded[$type][] = $identifier;
    }
    
    // Gets the diff from both arrays, in order to insert only the non-existing ones
    foreach ($clearCacheAdminAccess as $type => $identifiers) {
        $toBeAdded[$type] = array_diff($identifiers, $toBeAdded[$type] ?? []);
    }
    
    // Removes the empty indexes
    $toBeAdded = array_filter($toBeAdded);
}

if (count($toBeAdded)) {
    $sql = "INSERT INTO `admin_access_group_items` (`admin_access_group_id`, `identifier`, `type`) VALUES ";
    
    // Builds the insert query.
    foreach ($toBeAdded as $type => $identifiers) {
        foreach ($identifiers as $identifier) {
            $sql .= "(28, '{$identifier}', '{$type}'),";
        }
    }
    
    $sql       = rtrim($sql, ',') . ";";
    $t_success &= $this->query($sql, true);
}